#!/bin/bash
#SBATCH --mem=5G
#SBATCH --cpus-per-task=2
#SBATCH --time=1:00:00
#SBATCH --output=/scratch/shared/beegfs/yuki/fast/slurm/face/cleaning-YFCC-%a.out
#SBATCH --partition=compute
#SBACTH --open-mode=append
#SBATCH --job-name=facedet
#SBATCH --array=33-64 # 0-250%125
#SBATCH --constraint=10GbE



echo $SLURM_ARRAY_TASK_ID
X=$((${SLURM_ARRAY_TASK_ID}*80000))
Y=$(((${SLURM_ARRAY_TASK_ID} + 1)*80000))

in_file=_tmp_yfcc_${SLURM_ARRAY_TASK_ID}.txt
rm ${in_file}
results_dir='/scratch/shared/beegfs/yuki/data/fast/yfcc/face/'
< /users/yuki/YFCC-17M.txt tail -n +"$X" | head -n "$((Y - X))" >> ${in_file}

echo "from " ${X}
echo "to " ${Y}

# ETA 4-6Hz
/scratch/shared/beegfs/yuki/envs/py37/bin/python3 -W ignore check_broken.py ${in_file} ${SLURM_ARRAY_TASK_ID}